"use client";
import React from "react";
import { FaPlay } from "react-icons/fa";
import Image from "next/image";
import { useModal } from "@/context/ModalContext";

const VideoTour = () => {
  const { toggleModal } = useModal();
  return (
    <section>
      <div className="container">
        <div className="video-tour-container">
          <Image
            width={700}
            height={600}
            src="/images/video.jpg"
            alt="Resort View"
          />

          {/* Start Video Button */}
          <div
            className="video-overlay"
            onClick={() => toggleModal("Start Video Tour")}
          >
            <span>
              Start <br />
              Video
              <br /> Tour
            </span>
            <div className="play-icon">
              <FaPlay size={50} color="#000" />
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default VideoTour;
